# Figure 8, elife paper
# Prepared by : Charles Agoti
# Last updated : 29 Jun 2022

rm(list=ls())
library(tidyverse); library(dplyr);library("lubridate");  library(tidytree); library(readxl)
library(treeio); library(artyfarty);library(wesanderson); library(janitor); library(scales);
library(lubridate);library(ggalluvial); library(ggtree);library(patchwork); library(ggrepel);
library(writexl); library(svglite)
## Basic set-up
setwd("~/Dropbox/COVID-19/SECONDWAVE/global/")
color_coast <- c("#FF0000","#000000","#00FFFF",'#FFA500','#0000FF',"#FF00FF")
plot_color <- c("#FF0000", "#FFFF00", "#00EAFF", "#AA00FF", "#FF7F00", "#BFFF00", "#0095FF","#FF00AA","#FFD400", "#6AFF00", "#0040FF","#EDB9B9", "#B9D7ED", 
                "#E7E9B9", "#DCB9ED", "#B9EDE0", "#8F2323", "#23628F", "#8F6A23", "#6B238F", "#4F8F23", "#000000", "#737373", "#CCCCCC")
plot_color2=c("#000000","#C0C0C0","#696969","#FF0000","#F2D2BD",
             "#800000","#C9A9A6","#00FF00","#008000","#00FFFF","#BA6B57", "#FFA500","#9933FF",
             "#A4C639","#0000FF","#CCCCFF","#FF00FF","#55ACEE", "#b1bca0")

coast_counties <- c("Mombasa", "Kilifi", "Kwale", "Taita Taveta", "Tana River", "Lamu")


events_dta <- read.csv("~/Dropbox/COVID-19/SECONDWAVE/global/all_sequences/subsample1/mugration/annottated_tree_events.csv")%>%
  filter(Origin!="UNKNOWN")%>%
  mutate(eventdate=format(date_decimal(EventTime), "%Y-%m-%d"))%>%
  mutate(studyphase=as.character(ifelse(eventdate<"2020-09-16", "Wave 1", "Wave 2")))%>%
  mutate(eventdate=as.Date(eventdate))%>%
  mutate(Origin=recode(Origin, "non_Africa"="Global",
                       "non_Coastal_Kenya"="Other Kenya"))%>%
  mutate(Destination=recode(Destination, "non_Africa"="Global",
                      "non_Coastal_Kenya"= "Other Kenya"))%>%
  filter(!((Origin=="Global"|Origin=="Africa") & (Destination=="Global"|Destination=="Africa" )))%>%
  mutate(EventType=case_when(Origin%in%coast_counties & !Destination%in%coast_counties ~ "Export",
                             !Origin%in%coast_counties & Destination%in%coast_counties ~ "Import",
                             Origin%in%coast_counties & Destination%in%coast_counties ~ "Inter-county",
                             !Origin%in%coast_counties & Destination=="Other Kenya" ~ "Import to elsewhere Kenya",
                             Origin=="Other Kenya" & !Destination%in%coast_counties ~ "Export from elsewhere Kenya"))%>%
  mutate(EventType=factor(EventType, levels = c("Import",
                                                "Export",
                                                "Inter-county",
                                                "Import to elsewhere Kenya",
                                                "Export from elsewhere Kenya")))%>%
  filter(!EventType=="Import to elsewhere Kenya", !EventType=="Export from elsewhere Kenya")
glimpse(events_dta)
names(events_dta)

events_dta%>%select(EventType, Origin, Destination, studyphase)%>%
  mutate(count=1)%>%
  group_by(EventType, Origin, Destination, studyphase)%>%
  summarise(event_frequency=sum(count))%>%
  write.csv("~/Dropbox/COVID-19/SECONDWAVE/revision/Final/Figures/Figure 10/Source_data_1_flow_imports_exports_26Feb2021.csv", row.names=F, na='')


tabyl(events_dta, EventType)%>%adorn_totals(where=c("row", "col"))
tabyl(events_dta, Origin, EventType)%>%adorn_totals(where=c("row", "col"))
tabyl(events_dta, Destination, EventType)%>%adorn_totals(where=c("row", "col"))
tabyl(events_dta, Origin, Destination)%>%adorn_totals(where=c("row", "col"))

events_dta%>%filter(Origin%in%coast_counties)%>%
  filter(Destination%in%coast_counties)%>%
  tabyl(Origin, Destination)%>%
  adorn_totals(where=c("row", "col"))

#Generating the alluvium plot/flow diagram
Plot1<-ggplot(events_dta, aes(axis1 = Origin, axis2 = Destination)) +
  geom_alluvium(width = 1/4, aes(fill=EventType), decreasing = TRUE, alpha=0.65) +
  geom_stratum(width = 1/4, fill="white", color="black", decreasing = TRUE) +
  geom_label_repel(label.padding=0.25, size=2.5,stat = "stratum", min.y = 5,decreasing = TRUE, colour = "black", aes(label = after_stat(stratum)))+ ## Note: Can be uncommented to show country labels
  #scale_fill_manual(values=plot_color[c(3, 4,9,8,18)])+
  facet_wrap(studyphase~., nrow=2)+
  scale_fill_manual(values=c("black", "red", "blue"))+
  #scale_fill_manual(values = pal("five38"[c(2, 4, 5)]))+
  scale_x_discrete(limits = c("Origin", "Destination"), expand = c(.08, .08)) +
  scale_y_continuous(limits = c(0,350), minor_breaks = seq(0,350, 50), breaks = seq(0,350,100))+
  labs(y="Number of Events", tag="A")+
  #theme_minimal()+
  theme_scientific() +
  theme(axis.title.x = element_text(size = 11),
        axis.title.y = element_text(size = 11),
        axis.text.x = element_text(size = 11),
        axis.text.y = element_text(size = 11),
        strip.background = element_rect(fill="white", color = "black"),
        legend.position = "bottom",
        #legend.position = c(0.80, 0.80),
        legend.key.size = unit(0.35, "cm"),
        legend.spacing.x = unit(0.25, 'cm'),
        legend.spacing.y = unit(0.25, 'cm'),
        legend.text = element_text(size = 11),
        legend.title =element_text(size = 11),
        legend.background = element_rect(fill="#FFFFFF", color = NA),
        legend.box.background = element_blank())+
  guides(fill=guide_legend(ncol=1, title = "Event Type (A)", title.position = "top"), size=T)

pdf("~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Figures/Fig.8/Fig.8A.pdf", height= 3.95, width =9.02)
print(Plot1)
dev.off()
Plot1


events_dta%>%
  tabyl(EventType,studyphase)%>%
  adorn_percentages(denominator = "row")%>%
  adorn_pct_formatting(digits = 1)

Plot2<- events_dta%>%
  mutate(present=1)%>%
  group_by(studyphase, EventType)%>%
  summarise(Freq=sum(present))%>%
  #write.csv("~/Dropbox/COVID-19/SECONDWAVE/revision/Final/Figures/Figure 10/Source_data_2_imports_exports_by_wave_26Feb2021.csv", row.names = F, na="")
  ggplot(aes(x=studyphase, y=Freq))+
  #scale_fill_manual(values = wes_palette(n=3, name="GrandBudapest1"))+
  #scale_fill_manual(values = pal("color_blind"))+
  scale_fill_manual(values=c("black", "red", "blue"))+
  geom_col(aes(fill=EventType), color="white", size=0.2, position="dodge", width = 0.6)+
  #scale_x_date(date_labels = "%b\n%Y",date_breaks = "3 month")+
  #scale_y_continuous(limits = c(0,45), breaks = seq(0,45,10), minor_breaks = seq(0,45, 5))+
  labs(x="", y="Number of Events", tag="B")+
  theme_scientific()+
  theme(axis.title.x = element_text(size = 11),
        axis.title.y = element_text(size = 11),
        axis.text.x = element_text(size = 11, angle=0),
        axis.text.y = element_text(size = 11),
        plot.title = element_text(hjust = 0.5, size = 11, face="bold"),
        #legend.position = c(0.45, 0.90),
        legend.position = "right",
        legend.key.size = unit(0.35, "cm"),
        legend.spacing.x = unit(0.15, 'cm'),
        legend.spacing.y = unit(0.15, 'cm'),
        legend.text = element_text(size = 11),
        legend.title =element_text(size = 11),
        legend.background=element_rect(fill = alpha("white", 0)))+
  guides(fill=guide_legend(ncol=1, title = "Event Type (B)", title.position = "top"), size=T)
pdf("~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Figures/Fig.8/Fig.8B.pdf", width = 3.95, height = 3.51)
print(Plot2)
dev.off()
Plot2

Plot3 <-events_dta%>%
  mutate(count=1)%>%
  mutate(month=floor_date(eventdate, "month"))%>%
  group_by(month, EventType)%>%
  summarise(n=sum(count))%>%
  ggplot(aes(x=month, y=n, group=EventType))+
  geom_line(aes(color=EventType, linetype=EventType))+
  geom_point(aes(color=EventType, shape=EventType))+
  scale_linetype_manual(values=c("solid", "dashed", "dotted"), guide="none")+
  scale_color_manual(values=c("black", "red", "blue"))+
  scale_x_date(date_labels = "%b",date_breaks = "2 month")+
  
  scale_y_continuous(limits = c(0,60), breaks = seq(0,60,10), minor_breaks = seq(0,60, 5))+
  labs(x="Month in 2020/21", y="Number of Events", tag="C")+
  geom_vline(xintercept = as.Date("2020-09-16"), size=0.5, linetype="longdash", color="black")+
  geom_text(x=as.Date("2020-06-15"), y=60, label="Wave 1", size=3)+
  geom_text(x=as.Date("2020-12-15"), y=60, label="Wave 2", size=3)+
  theme_scientific()+
  theme(axis.title.x = element_text(size = 11),
        axis.title.y = element_text(size = 11),
        axis.text.x = element_text(size = 11, angle=0),
        axis.text.y = element_text(size = 11),
        plot.title = element_text(hjust = 0.5, size = 11, face="bold"),
        #legend.position = c(0.45, 0.90),
        legend.position = "right",
        legend.key.size = unit(0.25, "cm"),
        legend.spacing.x = unit(0.15, 'cm'),
        legend.spacing.y = unit(0.15, 'cm'),
        legend.text = element_text(size = 11),
        legend.title =element_text(size = 11),
        legend.background=element_rect(fill = alpha("white", 0)))+
  #legend.box.background = element_blank())+
  guides(shape=guide_legend(ncol=1, title = "Event Type (C)", title.position = "top"), 
         color=guide_legend(ncol=1, title = "Event Type (C)", title.position = "top"),size=T)
pdf("~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Figures/Fig.8/Fig.8C.pdf", width = 3.95, height = 3.51)
print(Plot3)
dev.off()
Plot3


Figure_8<- Plot1+(Plot2/Plot3)+plot_layout(guides=("collect"))
#pdf("~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Figures/Fig.8/Fig.8.pdf", width = 8.5, height = 5.95)
ggsave(file="~/Dropbox/COVID-19/SECONDWAVE/revisedcode/Figures/Fig.8/Fig.8.svg", plot=Figure_8, width = 8.5, height = 5.95)
print(Figure_8)
dev.off()
Figure_8
